
// Create Resource Descriptor
$instantResource = new ScriptObject()
{
	Class = "jungleLevel";
	Name = "jungleLevel";
	User = "TGB";
	LoadFunction = "jungleLevel::LoadResource";
	UnloadFunction = "jungleLevel::UnloadResource";
};

// Load Resource Function - Hooks into game
function jungleLevel::LoadResource( %this )
{
	
}


// Unload Resource Function - Remove from game Sim.
function jungleLevel::UnloadResource( %this )
{
	// We must clean up all the mess we've made in the Sim.
	if( isObject( %this.Data ) && %this.Data.GetCount() > 0 )
	{		
		while( %this.Data.getCount() > 0 )
		{
			%datablockObj = %this.Data.getObject( 0 );
			%this.Data.remove( %datablockObj );
			if( isObject( %datablockObj ) )
				%datablockObj.delete();
		}
	}
}

// Resource Data
$instantResource.Data = new SimGroup() 
{
	
   new t2dImageMapDatablock(coconutImageMap) {
      imageName = "./Textures/coconut";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(treeRoofImageMap) {
      imageName = "./Textures/treeRoof";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "512";
      cellHeight = "512";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(wall_tiled4ImageMap) {
      imageName = "./TiledTextures/wall_tiled4";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(pyritImageMap) {
      imageName = "./Textures/pyrit";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(blackStoneImageMap) {
      imageName = "./Textures/blackStone";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(fireclipImageMap) {
      imageName = "./Textures/fireclip";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "256";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
   new t2dAnimationDatablock(fireclipAnimation) {
      imageMap = "fireclipImageMap";
      animationFrames = "0 1 2 3 4 5 6 7 6 5 4 3 2 1";
      animationTime = "1.5";
      animationCycle = "1";
      randomStart = "0";
      startFrame = "0";
   };
   new t2dImageMapDatablock(bark_tiled2ImageMap) {
      imageName = "./TiledTextures/bark_tiled2";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(hive1ImageMap) {
      imageName = "./Textures/hive1";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bee1ImageMap) {
      imageName = "./Particles/bee1";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bushesImageMap3) {
      imageName = "./PaperAndMasks/bushes";
      imageMode = "KEY";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(palmTrunk02ImageMap) {
      imageName = "./Textures/palmTrunk02";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(palmLeaves2ImageMap) {
      imageName = "./Textures/palmLeaves2";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(palmLeavesImageMap) {
      imageName = "./Textures/palmLeaves";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
	
   new t2dAnimationDatablock(paperFlameAnimation) {
      imageMap = "bushesImageMap3";
      animationFrames = "7 8 10 9 10 8";
      animationTime = "0.5";
      animationCycle = "1";
      randomStart = "1";
      startFrame = "0";
   };

	new t2dImageMapDatablock(bushesWide2ImageMap) {
      imageName = "./Textures/bushesWide2";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "512";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bushGruenImageMap) {
      imageName = "./Textures/bushGruen";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(spark1ImageMap) {
      imageName = "./Textures/spark1";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "32";
      cellHeight = "32";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(spark2ImageMap) {
      imageName = "./Textures/spark2";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "32";
      cellHeight = "32";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(sparkLinkImage) {
      imageMode = "LINK";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      linkImageMaps = "spark1ImageMap spark2ImageMap";
      preload = "1";
      allowUnload = "0";
   };
   new t2dAnimationDatablock(sparkAnimation) {
      imageMap = "sparkLinkImage";
      animationFrames = "4 5 0 1 2 3 7 6";
      animationTime = "0.8";
      animationCycle = "1";
      randomStart = "0";
      startFrame = "0";
   };
	
	new t2dImageMapDatablock(bushBurnedImageMap) {
      imageName = "./Textures/bushBurned";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bark_tiled3ImageMap) {
      imageName = "./TiledTextures/bark_tiled3";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(monkeyHeadImageMap) {
      imageName = "./Textures/monkeyHead";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(mossStuffImageMap) {
      imageName = "./Textures/mossStuff";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "256";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
	
	new t2dImageMapDatablock(ground_tiledImageMap) {
	      imageName = "./TiledTextures/ground_tiled";
	      imageMode = "FULL";
	      frameCount = "-1";
	      filterMode = "SMOOTH";
	      filterPad = "0";
	      preferPerf = "1";
	      cellRowOrder = "1";
	      cellOffsetX = "0";
	      cellOffsetY = "0";
	      cellStrideX = "0";
	      cellStrideY = "0";
	      cellCountX = "-1";
	      cellCountY = "-1";
	      cellWidth = "0";
	      cellHeight = "0";
	      preload = "1";
	      allowUnload = "0";
	};
	new t2dImageMapDatablock(trunkTiledImageMap) {
	      imageName = "./TiledTextures/trunkTiled";
	      imageMode = "CELL";
	      frameCount = "-1";
	      filterMode = "SMOOTH";
	      filterPad = "1";
	      preferPerf = "1";
	      cellRowOrder = "1";
	      cellOffsetX = "0";
	      cellOffsetY = "0";
	      cellStrideX = "0";
	      cellStrideY = "0";
	      cellCountX = "-1";
	      cellCountY = "-1";
	      cellWidth = "256";
	      cellHeight = "256";
	      preload = "1";
	      allowUnload = "0";
	};
	   new t2dImageMapDatablock(throwingMonkeyImageMap) {
	      imageName = "./Textures/throwingMonkey";
	      imageMode = "FULL";
	      frameCount = "-1";
	      filterMode = "SMOOTH";
	      filterPad = "0";
	      preferPerf = "1";
	      cellRowOrder = "1";
	      cellOffsetX = "0";
	      cellOffsetY = "0";
	      cellStrideX = "0";
	      cellStrideY = "0";
	      cellCountX = "-1";
	      cellCountY = "-1";
	      cellWidth = "0";
	      cellHeight = "0";
	      preload = "1";
	      allowUnload = "0";
	   };
	
	new t2dImageMapDatablock(paper_greenImageMap) {
      imageName = "./TiledTextures/paper_green";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "256";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
	
	new t2dImageMapDatablock(roundCornersImageMap) {
      imageName = "./PaperAndMasks/scharf/roundCorners";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "512";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(treeTrunkImageMap) {
      imageName = "./PaperAndMasks/treeTrunk";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
	new t2dImageMapDatablock(branchesImageMap) {
	     imageName = "./PaperAndMasks/branches";
      imageMode = "KEY";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
  new t2dImageMapDatablock(jungleFloorImageMap) {
      imageName = "./Textures/jungleFloor";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bushesImageMap) {
      imageName = "./Textures/bushes";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "256";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bigLeavesImageMap) {
      imageName = "./Textures/bigLeaves";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "256";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bushesWideImageMap) {
      imageName = "./Textures/bushesWide";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "1";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "512";
      cellHeight = "256";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(bark_tiled1ImageMap) {
      imageName = "./TiledTextures/bark_tiled1";
      imageMode = "FULL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "1";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "0";
      cellHeight = "0";
      preload = "1";
      allowUnload = "0";
   };
};